package cn.com.duiba.activity.center.api.enums;

/**
 * @author: zhengwei
 * @date: 18/8/1 11:25
 * @description: 红包领奖状态
 */
public enum RedPacketRecordStatusEnum {

    UN_RECEIVE(0, "未领取"),
    RECEIVED_SUCCESS(1, "领取成功"),
    RECEIVED_FAIL(2, "领取失败"),
    ;

    private Integer status;
    private String desc;

    RedPacketRecordStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 校验状态
     * @param status
     * @return
     */
    public static boolean contains(Integer status){
        for (RedPacketRecordStatusEnum redPacketRecordStatusEnum : values()) {
            if (redPacketRecordStatusEnum.status.equals(status)) {
                return true;
            }
        }
        return false;
    }
}
