package cn.com.duiba.activity.center.api.params;

import java.io.Serializable;

/**
 * 微信刮红包活动 虚拟弹幕信息
 */
public class ScrapeRedPacketWinnerParam implements Serializable {
    private static final long serialVersionUID = 7043918066059531172L;

    private static final String TYPE_INVITE = "1";

    private static final String TYPE_MULTIPLECARD = "2";

    // 用户昵称
    private String userName;
    // 用户头像
    private String avatar;
    // 弹幕类型 1:邀请人数 2:翻倍卡
    private String type;
    // 展示值
    private String value;

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private ScrapeRedPacketWinnerParam() {
        // do Nothing
    }

    private ScrapeRedPacketWinnerParam(String userName, String avatar, String type, String value) {
        this.userName = userName;
        this.avatar = avatar;
        this.type = type;
        this.value = value;
    }

    public static ScrapeRedPacketWinnerParam generateInvite(String nickname, String avatar, String value) {
        return new ScrapeRedPacketWinnerParam(nickname, avatar, TYPE_INVITE, value);
    }

    public static ScrapeRedPacketWinnerParam genetareMultipleCard(String nickname, String avatar, String value) {
        return new ScrapeRedPacketWinnerParam(nickname, avatar, TYPE_MULTIPLECARD, value);
    }

}
