package cn.com.duiba.activity.center.api.remoteservice.carousel;

import cn.com.duiba.activity.center.api.dto.carousel.CarouselActivityRecordDto;
import cn.com.duiba.activity.center.api.params.CarouselQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 活动轮播记录
 *
 * @Author: xuwei
 * @Date: 2019/8/12 15:28
 */
@AdvancedFeignClient
public interface RemoteCarouselActivityRecordService {
    /**
     * 插入记录
     *
     * @param record
     */
    void insert(CarouselActivityRecordDto record);

    /**
     * 获取指定商品兑换类型头几条数据
     *
     * @param param
     * @return
     */
    List<CarouselActivityRecordDto> findTop4EachActivityType(CarouselQueryParam param);
}
