package cn.com.duiba.activity.center.api.remoteservice.joingroup;

import cn.com.duiba.activity.center.api.dto.joingroup.JoinGroupConfigDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhengjianhao
 * @date 18/9/14
 * @description 拼团活动配置管理端接口
 */
@AdvancedFeignClient
public interface RemoteJoinGroupBackendService {

    /**
     * 获取活动列表
     *
     * @param id
     * @param title
     * @param activityStatus
     * @param plannerName
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<JoinGroupConfigDto> pageApi(Long id, String title, String plannerName, Integer activityStatus, Integer pageNo, Integer pageSize) throws BizException;

    /**
     * 获取活动详情
     *
     * @param id
     * @return
     */
    JoinGroupConfigDto find(Long id) throws BizException;

    /**
     * 保存活动详情
     *
     * @param record
     * @return
     */
    boolean save(JoinGroupConfigDto record) throws BizException;

    /**
     * 更新活动状态
     *
     * @param status
     * @return
     */
    boolean updateStatus(Long id, Integer status) throws BizException;

    /**
     * 删除活动
     *
     * @param id
     * @return
     */
    boolean delete(Long id) throws BizException;
}
