package cn.com.duiba.activity.center.api.remoteservice.ngame;


import cn.com.duiba.activity.center.api.dto.ngame.NgameStockDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 
 * ClassName: RemoteNgameStockService <br/>
 * date: 2016年12月1日 下午4:04:25 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteNgameStockService {
	
    /**
     * 
     * findRemaining:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param relationId
     * @return
     * @since JDK 1.6
     */
	public NgameStockDto findRemaining(Long relationId);
	
	/**
	 * 
	 * subStock:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param subNumber
	 * @return
	 * @since JDK 1.6
	 */
	public int subStock(Long id, Integer subNumber);
	
	/**
	 * 
	 * addStock:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param addNumber
	 * @return
	 * @since JDK 1.6
	 */
	public int addStock(Long id, Integer addNumber);

	/**
	 * 
	 * findByGameOptionId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param gameOptionId
	 * @return
	 * @since JDK 1.6
	 */
	NgameStockDto findByGameOptionId(Long gameOptionId);

	/**
	 * 
	 * findByGameOptionIds:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param list
	 * @return
	 * @since JDK 1.6
	 */
	List<NgameStockDto> findByGameOptionIds(List<Long> list);

	/**
	 * 
	 * updateStock:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param ngameStockDto
	 * @since JDK 1.6
	 */
	void updateStock(NgameStockDto ngameStockDto);

	/**
	 * 
	 * add:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param ngameStockDto
	 * @return
	 * @since JDK 1.6
	 */
	NgameStockDto add(NgameStockDto ngameStockDto);

	/**
	 * 
	 * addBatch:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param list
	 * @since JDK 1.6
	 */
	void addBatch(List<NgameStockDto> list);
}
