package cn.com.duiba.activity.center.api.dto.equity;

import cn.com.duiba.activity.center.api.enums.equity.EquityTypeEnum;
import cn.com.duiba.activity.center.api.enums.equity.VerificationTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * @program: activity-all
 * @description: 权益配置
 * @author: Simba
 * @create: 2019-07-05 17:59
 **/
public class EquityConfigDto implements Serializable {

    private static final long serialVersionUID = -1662587828152063394L;
    private Long id;

    private Long appId;

    /**
     * 名称
     */
    private String name;

    /**
     * 类型：
     *
     * @see EquityTypeEnum
     */
    private Integer type;

    /**
     * 图片
     */
    private String image;

    /**
     * 起始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 关联的商品id
     */
    private String appItemIds;

    /**
     * 是否删除
     */
    private Integer deleted;

    /**
     * 记录创建时间
     */
    private Date gmtCreate;

    /**
     * 记录修改时间
     */
    private Date gmtModified;
    /**
     * 权益code
     */
    private String equityCode;
    /**
     * 权益描述
     */
    private String equityDesc;
    /**
     * 核销类型
     *
     * @see VerificationTypeEnum
     */
    private Integer verificationType;

    /**
     * 核销类型
     *
     * @see EquitySubTypeEnum
     */
    private Integer equitySubType;

    /**
     * 关联的网点ids
     */
    private String stationIds;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return type;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public String getAppItemIds() {
        return appItemIds;
    }

    public void setAppItemIds(String appItemIds) {
        this.appItemIds = appItemIds;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public String getEquityCode() {
        return equityCode;
    }

    public void setEquityCode(String equityCode) {
        this.equityCode = equityCode;
    }

    public String getEquityDesc() {
        return equityDesc;
    }

    public void setEquityDesc(String equityDesc) {
        this.equityDesc = equityDesc;
    }

    public Integer getVerificationType() {
        return verificationType;
    }

    public void setVerificationType(Integer verificationType) {
        this.verificationType = verificationType;
    }

    public Integer getEquitySubType() {
        return equitySubType;
    }

    public void setEquitySubType(Integer equitySubType) {
        this.equitySubType = equitySubType;
    }

    public String getStationIds() {
        return stationIds;
    }

    public void setStationIds(String stationIds) {
        this.stationIds = stationIds;
    }
}

