package cn.com.duiba.activity.center.api.dto.equity;

import java.io.Serializable;
import java.util.Date;

/**
 *  权益匹配身份核销记录
 */
public class EquityVerificationRecordDto implements Serializable {

    private static final long serialVersionUID = 1672244725350130209L;
    /**
     *
     */
    private Long id;

    /**
     * 权益id
     */
    private Long equityId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 开发者兑换码
     */
    private String devCode;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 开发者用户id
     */
    private String partnerUserId;

    /**
     * 核销时间
     */
    private Date verificationTime;

    /**
     * 商品skuId
     */
    private Long appSkuId;

    /**
     * 商品id
     */
    private Long appItemId;

    /**
     * 记录创建时间
     */
    private Date gmtCreate;

    /**
     * 记录修改时间
     */
    private Date gmtModified;

    /**
     * 状态：1.处理中；2.成功；3.失败
     * @see cn.com.duiba.activity.center.api.enums.equity.VerificationRecordStatusEnum
     */
    private Integer status;

    /**
     * 失败原因
     */
    private String failReason;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setEquityId(Long equityId) {
        this.equityId = equityId;
    }

    public Long getEquityId() {
        return equityId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setDevCode(String devCode) {
        this.devCode = devCode;
    }

    public String getDevCode() {
        return devCode;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setVerificationTime(Date verificationTime) {
        this.verificationTime = verificationTime;
    }

    public Date getVerificationTime() {
        return verificationTime;
    }

    public void setAppSkuId(Long appSkuId) {
        this.appSkuId = appSkuId;
    }

    public Long getAppSkuId() {
        return appSkuId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return status;
    }

    public String getFailReason() {
        return failReason;
    }

    public void setFailReason(String failReason) {
        this.failReason = failReason;
    }
}

