package cn.com.duiba.activity.center.api.enums;

/**
 * 礼包项类型枚举
 */
public enum ElasticGiftsTermTypeEnum {

    DUIBA(1, "兑吧商品"),
    APP(2, "app自有商品"),
    PLATFORM(3, "平台券商品"),
    ADVERT(4, "广告券商品");

    private int    value;
    private String desc;

    ElasticGiftsTermTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    /**
     * 
     * value:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public int value() {
        return this.value;
    }

    /**
     * 
     * desc:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public String desc() {
        return this.desc;
    }

    /**
     * 
     * fromValue:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param value
     * @return
     * @since JDK 1.6
     */
    public static ElasticGiftsTermTypeEnum fromValue(int value) {
        for (ElasticGiftsTermTypeEnum it : ElasticGiftsTermTypeEnum.values()) {
            if (value == it.value()) {
                return it;
            }
        }
        return null;
    }
}
