package cn.com.duiba.activity.center.api.enums.equity;

import java.util.Objects;

/**
 * @program: activity-center
 * @description: 权益批次类型枚举类
 * @author: 刘凯
 **/
public enum EquityBatchTypeEnum {
    CODE_EXCHANGE(1, "权益code"),
    WHITE_LIST_EXCHANGE(2, "权益白名单"),
    ;
    private Integer code;
    private String desc;

    EquityBatchTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static EquityBatchTypeEnum ofValue(Integer code) {
        for (EquityBatchTypeEnum equityTypeEnum : values()) {
            if (Objects.equals(equityTypeEnum.getCode(), code)) {
                return equityTypeEnum;
            }
        }
        return null;
    }
}

