package cn.com.duiba.activity.center.api.dto.guessredpacket;

import java.io.Serializable;
import java.util.Date;

/**
 * 该dto和数据库字段匹配
 * @see GuessRedPacketInfoDto 这个dto在center层没有使用
 * @author chengsiyi
 * @date 2019/3/26 16:39
 */
public class NewGuessRedPacketInfoDto implements Serializable {

    private static final long serialVersionUID = 5932369329889054650L;

    private Long id;

    /**
     * appID
     */
    private Long appId;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 红包id
     */
    private Long redPacketId;

    /**
     * 红包金额
     */
    private Long amount;

    /**
     * 起始区间
     */
    private Long bonusMin;

    /**
     * 结束区间
     */
    private Long bonusMax;

    /**
     * 领奖状态
     * @see cn.com.duiba.activity.center.api.enums.GuessRedPacketStatusEnum
     */
    private Integer packetStatus;

    /**
     * 猜中用户
     */
    private Long guessedConsumerId;

    /**
     * 失效时间
     */
    private Date expireTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public NewGuessRedPacketInfoDto() {
    }

    public NewGuessRedPacketInfoDto(Long appId, Long activityId, Long consumerId) {
        this.appId = appId;
        this.activityId = activityId;
        this.consumerId = consumerId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getRedPacketId() {
        return redPacketId;
    }

    public void setRedPacketId(Long redPacketId) {
        this.redPacketId = redPacketId;
    }

    public Long getAmount() {
        return amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Long getBonusMin() {
        return bonusMin;
    }

    public void setBonusMin(Long bonusMin) {
        this.bonusMin = bonusMin;
    }

    public Long getBonusMax() {
        return bonusMax;
    }

    public void setBonusMax(Long bonusMax) {
        this.bonusMax = bonusMax;
    }

    public Integer getPacketStatus() {
        return packetStatus;
    }

    public void setPacketStatus(Integer packetStatus) {
        this.packetStatus = packetStatus;
    }

    public Long getGuessedConsumerId() {
        return guessedConsumerId;
    }

    public void setGuessedConsumerId(Long guessedConsumerId) {
        this.guessedConsumerId = guessedConsumerId;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
