package cn.com.duiba.activity.center.api.remoteservice.lotterysquare;

import cn.com.duiba.activity.center.api.dto.lotterysquare.LotterySquareBonusConfigDto;
import cn.com.duiba.activity.center.api.enums.LSPrizeTypeEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import java.util.List;

/**
 * Created by Liugq on 2018/12/24.
 */
@AdvancedFeignClient
public interface RemoteLotterySquareBonusConfigService {
    /**
     * 查询活动下特定类型的奖励配置
     * @param actId
     * @param prizeType
     * @return
     */
    List<LotterySquareBonusConfigDto> selectBonusConfigByActIdAndConsumerType(Long actId, LSPrizeTypeEnum prizeType);

    /**
     * 查询活动下的奖励配置
     * @param actId
     * @return
     */
    List<LotterySquareBonusConfigDto> selectBonusConfigByActId(Long actId);
}
