/**
 * Project Name:activity-center-api
 * File Name:PagingParameters.java
 * Package Name:cn.com.duiba.activity.center.api.dto
 * Date:2016年9月5日下午3:36:57
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.api.dto;

import java.io.Serializable;

/**
 * ClassName:PagingParameters <br/>
 * Date:     2016年9月5日 下午3:36:57 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class PagingParameters implements Serializable{

    private static final long serialVersionUID = 6162428244842454791L;
    private Integer max;
    private Integer offset;
    private Integer pageSize;
    private Integer currentPage;
    
    private static final int DefaultCurrentPage=1;
    private static final int DefalutPageSize = 20;
    
    /**
     * 
     * Creates a new instance of PagingParameters.
     *
     */
    public PagingParameters(){
        this.max = DefalutPageSize;
        this.offset = 0;
        this.pageSize = DefalutPageSize;
        this.currentPage = DefaultCurrentPage;
    }
    
    /**
     * 
     * Creates a new instance of PagingParameters.
     *
     * @param currentPage
     * @param pageSize
     */
    public PagingParameters(int currentPage,int pageSize){
        this.setCurrentPageAndPageSize(currentPage, pageSize);
    }
    
    public Integer getMax() {
        return max;
    }
    
    public Integer getOffset() {
        return offset;
    }
    
    public Integer getPageSize() {
        return pageSize;
    }
    
    public Integer getCurrentPage() {
        return currentPage;
    }
    
    /**
     * 
     * setOffsetAndMax:(这里用一句话描述这个方法的作用). <br/>
     * @param offset
     * @param max
     * @since JDK 1.6
     */
    public void setOffsetAndMax(int offset,int max){
        this.offset = offset;
        this.max = max;
        this.pageSize = max;
        this.currentPage = offset/max+1;
    }
    
    /**
     * 
     * setCurrentPageAndPageSize:(这里用一句话描述这个方法的作用). <br/>
     * @param currentPage
     * @param pageSize
     * @since JDK 1.6
     */
    public void setCurrentPageAndPageSize(int currentPage,int pageSize){
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.max = pageSize;
        this.offset = pageSize*(currentPage-1);
    }
    
}

