package cn.com.duiba.activity.center.api.remoteservice.zhuanzhuan;

import cn.com.duiba.activity.center.api.dto.zhuanzhuan.FriendPointLogDto;
import cn.com.duiba.activity.center.api.params.FriendPointBaseQueryParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * Created by sty on 2018/4/29.
 */
@AdvancedFeignClient
public interface RemoteFriendPointService {
  /**
   * 插入记录
   * @param friendPointLogDto
   * @return
   */
  FriendPointLogDto insert(FriendPointLogDto friendPointLogDto);

  /**
   * 根据用户id，活动id，appid查询对应的记录信息
   * @param param
   * @return
   */
  FriendPointLogDto findByUserAndAct(FriendPointBaseQueryParam param);

  /**
   * 行锁更新用户好友力点数，存变更数量
   * @param friendPointLogDto
   * @return
   */
  int updateFriendPoint(FriendPointLogDto friendPointLogDto);

  /**
   * 更新用户是否是新用户和用户是否被助力过
   * @param friendPointLogDto
   * @return
   */
  int updateUserInfo(FriendPointLogDto friendPointLogDto);

  /**
   * 行锁更新老用户助力的次数，存变更数量
   * @param friendPointLogDto
   * @return
   */
  int updateOldFriendHelp(FriendPointLogDto friendPointLogDto);
}
