package cn.com.duiba.activity.center.api.dto.creditsfarm;

import java.io.Serializable;
import java.util.Date;

/**
* 积分农场活动表
*/
public class CreditsFarmActDto implements Serializable {

    private static final long serialVersionUID = 5092921138936658310L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 应用id
    */
    private Long appId;

    /**
    * 活动标题
    */
    private String title;

    /**
    * 活动投放应用类型（ 0-app;1-公众号;2-小程序）用逗号隔开
    */
    private String appType;

    /**
    * 活动玩法 （0-成本可控型）
    */
    private Integer playType;

    /**
    * 活动规则
    */
    private String rule;

    /**
    * 兑换奖品需要的果实（g）
    */
    private Integer prizeCost;

    /**
    * 每日种植次数上限
    */
    private Integer dayCropLimit;
    /**
     * 每日营养液数量上限（当前是固定必须为此值）
     */
    private Integer nutritionCountLimit;

    /**
    * 积分回收率（%）
    */
    private Integer takeBackRatio;

    /**
    * 开始时间
    */
    private Date startTime;

    /**
    * 结束时间
    */
    private Date endTime;

    /**
    * 小程序授权地址
    */
    private String authorizeUrl;

    /**
    * 公众号二维码
    */
    private String wechatQrCode;

    /**
     * 非微信授权分享开关，0:关，1:开
     */
    private Integer nonWechatShareSwitch;

    /**
     * 免登链接
     */
    private String nonRegistrationUrl;

    /**
     * 活动缩略图 - 入库活动用
     */
    private String smallImage;

    /**
     * 出售开关
     */
    private boolean saleSwitch;

    public Integer getNonWechatShareSwitch() {
        return nonWechatShareSwitch;
    }

    public void setNonWechatShareSwitch(Integer nonWechatShareSwitch) {
        this.nonWechatShareSwitch = nonWechatShareSwitch;
    }

    public String getNonRegistrationUrl() {
        return nonRegistrationUrl;
    }

    public void setNonRegistrationUrl(String nonRegistrationUrl) {
        this.nonRegistrationUrl = nonRegistrationUrl;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return title;
    }

    public String getAppType() {
        return appType;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public Integer getPrizeCost() {
        return prizeCost;
    }

    public void setPrizeCost(Integer prizeCost) {
        this.prizeCost = prizeCost;
    }

    public void setPlayType(Integer playType) {
        this.playType = playType;
    }

    public Integer getPlayType() {
        return playType;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getRule() {
        return rule;
    }

    public void setDayCropLimit(Integer dayCropLimit) {
        this.dayCropLimit = dayCropLimit;
    }

    public Integer getDayCropLimit() {
        return dayCropLimit;
    }

    public void setTakeBackRatio(Integer takeBackRatio) {
        this.takeBackRatio = takeBackRatio;
    }

    public Integer getTakeBackRatio() {
        return takeBackRatio;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setAuthorizeUrl(String authorizeUrl) {
        this.authorizeUrl = authorizeUrl;
    }

    public String getAuthorizeUrl() {
        return authorizeUrl;
    }

    public void setWechatQrCode(String wechatQrCode) {
        this.wechatQrCode = wechatQrCode;
    }

    public String getWechatQrCode() {
        return wechatQrCode;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public Integer getNutritionCountLimit() {
        return nutritionCountLimit;
    }

    public void setNutritionCountLimit(Integer nutritionCountLimit) {
        this.nutritionCountLimit = nutritionCountLimit;
    }

    public boolean getSaleSwitch() {
        return saleSwitch;
    }

    public void setSaleSwitch(boolean saleSwitch) {
        this.saleSwitch = saleSwitch;
    }
}

