package cn.com.duiba.activity.center.api.dto.richman;

import cn.com.duiba.activity.center.api.enums.richman.RichManArriveEndingEventEnum;
import cn.com.duiba.activity.center.api.enums.richman.RichManLocationEventEnum;
import cn.com.duiba.activity.center.api.enums.richman.RichManPassEndingEventEnum;

import java.util.Map;

/**
 * 大富翁  地图配置
 * 代表一场游戏配置
 * 作为operatingActivity的拓展信息，保存一些大富翁相关的配置
 * @author 歪大哥😁
 * @date 2020-08-14.
 */
public class RichManMapDto {

    /**
     * 关联入库活动
     */
    private Long operatingActivityId;

    /**
     * 到达终点时的事件, 掷出的点数正好到达终点时触发，区别于经过终点
     * @see RichManArriveEndingEventEnum#getCode()
     */
    private Integer arriveEndingEvent;

    /**
     * 经过终点时的事件, 当次移动到终点时还要继续移动时触发，区别于到达终点
     * @see RichManPassEndingEventEnum#getCode()
     */
    private Integer passEndingEvent;

    /**
     * 总格子数
     */
    private Integer totalCount;

    /**
     * 包含有效事件的格子 映射, 空格子不会出现
     * 格子事件见
     * @see RichManLocationEventEnum#getCode()
     *
     */
    private Map<Integer, RichManLocationDto> locationsMapping;

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public Integer getArriveEndingEvent() {
        return arriveEndingEvent;
    }

    public void setArriveEndingEvent(Integer arriveEndingEvent) {
        this.arriveEndingEvent = arriveEndingEvent;
    }

    public Integer getPassEndingEvent() {
        return passEndingEvent;
    }

    public void setPassEndingEvent(Integer passEndingEvent) {
        this.passEndingEvent = passEndingEvent;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Map<Integer, RichManLocationDto> getLocationsMapping() {
        return locationsMapping;
    }

    public void setLocationsMapping(Map<Integer, RichManLocationDto> locationsMapping) {
        this.locationsMapping = locationsMapping;
    }
}
