package cn.com.duiba.activity.center.api.enums.richman;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 大富翁 地点触发事件类型
 * @author 歪大哥😁
 * @date 2020-08-14.
 */
public enum RichManLocationEventEnum {


    GO(1, "勇往直前"),

    BACK_OFF(2, "退避三舍"),

    LUCK_DRAW(3, "碰碰运气"),

    ;

    private int code;

    private String desc;

    RichManLocationEventEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    private static Map<Integer, RichManLocationEventEnum> map;

    static {
        Map<Integer, RichManLocationEventEnum> temp = Maps.newHashMap();

        for (RichManLocationEventEnum value : values()) {
            temp.put(value.code, value);
        }
        map = temp;
    }

    public static RichManLocationEventEnum getByCode(Integer code) {
        return map.get(code);
    }

}
