package cn.com.duiba.activity.center.api.enums.richman;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 大富翁  抽奖事件 类型
 * @author 歪大哥😁
 * @date 2020-08-14.
 */
public enum RichManLuckDrawTypeEnum {

    RANDOM(1, "听天由命"),

    FIRST_COME_FIRST_SERVED(2, "捷足先登"),
    ;

    private int code;
    private String desc;

    RichManLuckDrawTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static Map<Integer, RichManLuckDrawTypeEnum> map;

    static {
        Map<Integer, RichManLuckDrawTypeEnum> temp = Maps.newHashMap();

        for (RichManLuckDrawTypeEnum value : values()) {
            temp.put(value.code, value);
        }
        map = temp;
    }

    public static RichManLuckDrawTypeEnum getByCode(Integer code) {
        return map.get(code);
    }

}
