package cn.com.duiba.activity.center.api.remoteservice.richman;

import cn.com.duiba.activity.center.api.dto.richman.RichManPieceDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 寻宝大富翁 棋子信息服务
 * @author 歪大哥😁
 * @date 2020-08-17.
 */
@AdvancedFeignClient
public interface RemoteRichManPieceService {


    /**
     * 根据活动id和用户id查询棋子
     * @param operatingActivityId
     * @param consumerId
     * @return  棋子信息
     */
    RichManPieceDto findByOperatingActivityIdAndConsumerId(Long operatingActivityId, Long consumerId);

    /**
     * 初始化用户棋子
     * @return  棋子id
     */
    Long initPiece(RichManPieceDto piece);

    /**
     * 增加用户积分消耗
     * @param id  棋子id
     * @param delta  增加的积分数
     * @return
     */
    Integer increaseCreditsCost(Long id, Integer delta);

    /**
     * 减少用户积分消耗
     * @param id  棋子id
     * @param delta  减少的积分数
     * @return
     */
    Integer decreaseCreditsCost(Long id, Integer delta);

    /**
     * 将棋子放到新的location上
     * @param id  棋子id
     * @param newLocation  新的location
     * @return 新的location
     */
    Integer changeLocation(Long id, Integer newLocation);

}
