package cn.com.duiba.activity.center.api.remoteservice.equity;

import cn.com.duiba.activity.center.api.dto.equity.EquityMerchantDto;
import cn.com.duiba.activity.center.api.dto.equity.EquityMerchantEmployeeDto;
import cn.com.duiba.activity.center.api.request.equity.MerchantQueryRequest;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.api.bo.page.Page;

import java.util.List;

/**
 * Created by xutao on 2020/7/28.
 */
@AdvancedFeignClient
public interface RemoteMerchantInfoService {
    Long save(EquityMerchantDto equityMerchantDto) throws BizException;

    Integer updateAllById(EquityMerchantDto equityMerchantDto) throws BizException;

    Integer updateStatusById(EquityMerchantDto equityMerchantDto) throws BizException;

    EquityMerchantDto getAllById(Long id);

    EquityMerchantDto getMerchantById(Long id);

    Page<EquityMerchantDto> findPageByCondition(MerchantQueryRequest merchantQueryRequest) throws BizException;

    List<EquityMerchantDto> findMerchantByCondition(MerchantQueryRequest merchantQueryRequest) throws BizException;

    Integer batchSaveEmployee(List<EquityMerchantEmployeeDto> employeeDtoList);

    Integer batchSaveMerchant(List<EquityMerchantDto> equityMerchantDtoList);

    List<EquityMerchantDto> findMerchantByCodeList(Long appId, List<String> merchantCodeList);

    List<EquityMerchantDto> findMerchantByIds(List<Long> ids);
}
