package cn.com.duiba.activity.center.api.enums.creditsfarm;

/**
 * 任务类型 1-签到 2-种植 3-分享
 */
public enum ExchangeTypeEnum {
    EXCHANGE_TYPE_PRIZE(1, "奖品"),
    EXCHANGE_TYPE_CREDITS(2, "积分"),
    ;


    private Integer code;
    private String desc;

    ExchangeTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ExchangeTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ExchangeTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
