package cn.com.duiba.activity.center.api.params;

import static cn.com.duiba.activity.center.api.enums.ActivityTypeEnum.ACTIVITY_TOOL;
import static cn.com.duiba.activity.center.api.enums.ActivityTypeEnum.GAME;
import static cn.com.duiba.activity.center.api.enums.ActivityTypeEnum.GUESS;
import static cn.com.duiba.activity.center.api.enums.ActivityTypeEnum.PLUGIN;
import static cn.com.duiba.activity.center.api.enums.ActivityTypeEnum.QUESTION_ANSWER;
import static cn.com.duiba.activity.center.api.enums.ActivityTypeEnum.QUIZZ;
import static cn.com.duiba.activity.center.api.enums.ActivityTypeEnum.SECONDS_KILL;
import static cn.com.duiba.activity.center.api.enums.ActivityTypeEnum.ZHANGTI_ACTIVITY;

import java.io.Serializable;
import java.util.List;

import cn.com.duiba.activity.center.api.enums.ActivityTypeEnum;
import cn.com.duiba.activity.center.api.exception.ActivityParamsException;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;

/**
 * Created by liuyao on 2017/2/8.
 */
public class MainmeetParams implements Serializable {

    private static final long serialVersionUID = 6156800903487958570L;
    /**
     * 主会场支持的活动类型(后期在添加类型时,必须确认活动适配层已经支持了此活动类型)
     */
    public static final ImmutableSet<ActivityTypeEnum> MAIN_MEET_ACTIVITYS = ImmutableSet.of(
            ACTIVITY_TOOL,ZHANGTI_ACTIVITY,QUESTION_ANSWER,SECONDS_KILL,QUIZZ,GAME,GUESS,PLUGIN
    );

    private Long developerId;
    private Long appId;
    private List<MainmeetActivityParams> activityList = Lists.newArrayList();

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public void addActivitys(MainmeetActivityParams activity){
        if(!MAIN_MEET_ACTIVITYS.contains(activity.getType())){
            throw new ActivityParamsException("主会场不支持"+activity.getType().getName());
        }
        activityList.add(activity);
    }

    public List<MainmeetActivityParams> getActivityList(){
        return activityList;
    }

}
