package cn.com.duiba.activity.center.api.dto.happy_code;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.Date;

/**
 * Created by hww on 2017/11/7\
 */
public class HappyCodePhaseDto extends BaseDto{

    private static final long serialVersionUID = 4995736437295245031L;

    /** 未开启 */
    public static final int STATUS_WAIT_FOR_START = 0;
    /** 进行中 */
    public static final int STATUS_OPENING = 1;
    /** 待开奖 */
    public static final int STATUS_WAIT_OPEN_PRIZE = 2;
    /** 已开奖 */
    public static final int STATUS_END = 3;

    /** 到量开奖模式 */
    public static final int LOTTERY_TYPE_NUMBER = 0;
    /** 到时开奖模式 */
    public static final int LOTTERY_TYPE_TIME = 1;
    /** 扑克牌开奖模式 */
    public static final int LOTTERY_TYPE_POKER = 2;

    /** 扑克牌模式默认发放数量 */
    public static final int POKER_DEFAULT_SEND_AMOUNT = 99999999;

    /**
     * 开心码模式A
     * MMDD + 2位期数id + 6位随机码
     */
    public static final int CODE_TYPE_A = 0;

    /**
     * 开心码模式B
     * MMDD + 8位随机码
     */
    public static final int CODE_TYPE_B = 1;

    /**
     * 开心码扑克牌模式
     */
    public static final int CODE_TYPE_POKER = 2;

    /** 到时开奖 开奖时间循环模式 1天循环 */
    public static final int PRIZE_LOOP_TYPE_A = 0;
    /** 到时开奖 开奖时间循环模式 3天循环 */
    public static final int PRIZE_LOOP_TYPE_B = 1;
    /** 到时开奖 开奖时间循环模式 7天循环 */
    public static final int PRIZE_LOOP_TYPE_C = 2;

    /** 到时开奖 开奖订单范围 当期下所有开奖当天凌晨0点之前所发的码 */
    public static final int PRIZE_ORDER_AREA_A = 0;
    /** 到时开奖 开奖订单范围 当期下所有当天凌晨0点-开奖时刻之间所发的码*/
    public static final int PRIZE_ORDER_AREA_B = 1;
    /** 到时开奖 开奖订单范围 当期下所有开奖时刻之前所发的码*/
    public static final int PRIZE_ORDER_AREA_C = 2;

    /** 到时开奖 期次循环模式 自定义模式 */
    public static final int CYCLE_TYPE_A = 0;
    /** 到时开奖 期次循环模式 自然月模式 */
    public static final int CYCLE_TYPE_B = 1;

    /** 主键id */
    private Long id;
    /** 赛事基础配置信息id */
    private Long basicId;
    /** 标题 */
    private String title;
    /** 副标题 */
    private String subTitle;
    /** 规则 */
    private String rule;
    /** 期次号 */
    private String phaseNumber;
    /** 发放开心码数量 */
    private Integer codeCount;
    /** 期次状态 */
    private Integer phaseStatus;
    /** 期次序列 */
    private Integer payload;
    /** 开奖类型 */
    private Integer lotteryType;
    /** 开心码配置 */
    private Integer codeType;
    /** 中奖人数 */
    private Integer winnerCount;
    /** 中奖用户id */
    private String winnerId;
    /** 开心码商品id */
    private Long codeItemId;
    /** 开心码商品名称 */
    private String codeItemName;
    /** 开心码商品使用提示 */
    private String codeItemTips;
    /** 删除 */
    private Integer deleted;
    /** 创建时间 */
    private Date gmtCreate;
    /** 更新时间 */
    private Date gmtModified;

    /** 到时开奖模式 开奖时间 */
    private Date firstPrizeDate;
    /** 到时开奖模式 下次开奖时间 */
    private Date nextPrizeDate;
    /** 到时开奖模式 开奖时间循环模式 */
    private Integer prizeLoopType;
    /** 到时开奖模式 开奖订单范围 */
    private Integer prizeOrderArea;
    /** 到时开奖模式 本期开始时间 */
    private Date startDate;
    /** 到时开奖模式 本期结束时间 */
    private Date endDate;
    /** 到时开奖模式 周期循环模式  */
    private Integer cycleType;
    /** 到时开奖模式 自定义循环周期天数 */
    private Integer cycleNumber;
    /** 到时开奖模式 是否删除中奖用户订单 */
    private Integer delWinnerOrder;
    /** 中奖扑克牌（扑克牌模式特有）*/
    private String winPoker;
    /** 扑克牌模式开奖间隔（期次结束后的第几天）*/
    private Integer pokerTakePrizeCycle;
    /** 扑克牌开奖时间点*/
    private String pokerTakePrizeTime;
    /**
     * 降级类型
     */
    private Integer fallbackType;

    public String getPokerTakePrizeTime() {
        return pokerTakePrizeTime;
    }

    public void setPokerTakePrizeTime(String pokerTakePrizeTime) {
        this.pokerTakePrizeTime = pokerTakePrizeTime;
    }

    public String getWinPoker() {
        return winPoker;
    }

    public void setWinPoker(String winPoker) {
        this.winPoker = winPoker;
    }

    public Integer getPokerTakePrizeCycle() {
        return pokerTakePrizeCycle;
    }

    public void setPokerTakePrizeCycle(Integer pokerTakePrizeCycle) {
        this.pokerTakePrizeCycle = pokerTakePrizeCycle;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getBasicId() {
        return basicId;
    }

    public void setBasicId(Long basicId) {
        this.basicId = basicId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubTitle() {
        return subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public String getPhaseNumber() {
        return phaseNumber;
    }

    public void setPhaseNumber(String phaseNumber) {
        this.phaseNumber = phaseNumber;
    }

    public Integer getCodeCount() {
        return codeCount;
    }

    public void setCodeCount(Integer codeCount) {
        this.codeCount = codeCount;
    }

    public Integer getPhaseStatus() {
        return phaseStatus;
    }

    public void setPhaseStatus(Integer phaseStatus) {
        this.phaseStatus = phaseStatus;
    }

    public Integer getPayload() {
        return payload;
    }

    public void setPayload(Integer payload) {
        this.payload = payload;
    }

    public Integer getLotteryType() {
        return lotteryType;
    }

    public void setLotteryType(Integer lotteryType) {
        this.lotteryType = lotteryType;
    }

    public Integer getCodeType() {
        return codeType;
    }

    public void setCodeType(Integer codeType) {
        this.codeType = codeType;
    }

    public Integer getWinnerCount() {
        return winnerCount;
    }

    public void setWinnerCount(Integer winnerCount) {
        this.winnerCount = winnerCount;
    }

    public String getWinnerId() {
        return winnerId;
    }

    public void setWinnerId(String winnerId) {
        this.winnerId = winnerId;
    }

    public Long getCodeItemId() {
        return codeItemId;
    }

    public void setCodeItemId(Long codeItemId) {
        this.codeItemId = codeItemId;
    }

    public String getCodeItemName() {
        return codeItemName;
    }

    public void setCodeItemName(String codeItemName) {
        this.codeItemName = codeItemName;
    }

    public String getCodeItemTips() {
        return codeItemTips;
    }

    public void setCodeItemTips(String codeItemTips) {
        this.codeItemTips = codeItemTips;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getFirstPrizeDate() {
        return firstPrizeDate;
    }

    public void setFirstPrizeDate(Date firstPrizeDate) {
        this.firstPrizeDate = firstPrizeDate;
    }

    public Date getNextPrizeDate() {
        return nextPrizeDate;
    }

    public void setNextPrizeDate(Date nextPrizeDate) {
        this.nextPrizeDate = nextPrizeDate;
    }

    public Integer getPrizeLoopType() {
        return prizeLoopType;
    }

    public void setPrizeLoopType(Integer prizeLoopType) {
        this.prizeLoopType = prizeLoopType;
    }

    public Integer getPrizeOrderArea() {
        return prizeOrderArea;
    }

    public void setPrizeOrderArea(Integer prizeOrderArea) {
        this.prizeOrderArea = prizeOrderArea;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getCycleType() {
        return cycleType;
    }

    public void setCycleType(Integer cycleType) {
        this.cycleType = cycleType;
    }

    public Integer getCycleNumber() {
        return cycleNumber;
    }

    public void setCycleNumber(Integer cycleNumber) {
        this.cycleNumber = cycleNumber;
    }

    public Integer getDelWinnerOrder() {
        return delWinnerOrder;
    }

    public void setDelWinnerOrder(Integer delWinnerOrder) {
        this.delWinnerOrder = delWinnerOrder;
    }

    public Integer getFallbackType() {
        return fallbackType;
    }

    public void setFallbackType(Integer fallbackType) {
        this.fallbackType = fallbackType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
