package cn.com.duiba.activity.center.api.enums.equity;

import java.util.Objects;

/**
 * @program: activity-center
 * @description: 线下核销 - 权益类型枚举类
 * @author: Simba
 * @create: 2019-08-05 15:27
 **/
public enum OfflineEquityTypeEnum {
    MATCH_MERCHANT(1, "匹配商家码兑换"),
    MATCH_STATION(2, "匹配网点核销"),
    MATCH_QRCODE(3, "识别二维码兑换"),
    ;
    private Integer code;
    private String desc;

    OfflineEquityTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static OfflineEquityTypeEnum ofValue(Integer code) {
        for (OfflineEquityTypeEnum equityTypeEnum : values()) {
            if (Objects.equals(equityTypeEnum.getCode(), code)) {
                return equityTypeEnum;
            }
        }
        return null;
    }
}

