package cn.com.duiba.activity.center.api.remoteservice.equity;

import cn.com.duiba.activity.center.api.dto.equity.StationItemRelDto;
import cn.com.duiba.activity.center.api.request.equity.StationStockRelRequest;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteStationItemRelService {


    Long save(StationItemRelDto stationItemRelDto);

    Integer updateById(StationItemRelDto stationItemRelDto);

    StationItemRelDto getById(Long id);

    List<StationItemRelDto> listByIds(List<Long> ids);

    StationItemRelDto getByUxAidOnum(Long appId, String orderNum);

    List<StationItemRelDto> findByPartCondtion(StationStockRelRequest stationStockRelRequest)  throws BizException;

    Integer deleteById(Long id);

    Integer getWaitVerifyRecordNum(Long id) throws BizException;

    Integer updateRelStatuByIdAndLimitSize(Long stationStockId,Integer limitSize) throws BizException;

    List<StationItemRelDto> listByConsumerIdAndAppItemIds(Long consumerId, List<Long> appItemIds);

}
