package cn.com.duiba.activity.center.api.remoteservice.managermarket;

import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketRankDto;
import cn.com.duiba.activity.center.api.dto.managermarket.ManagerMarketStatisticsDataDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @date 2020-08-19
 * @author fengjun
 * @email fengjun@duiba.com.cn
 * @desc 客户经理营销中心数据相关的接口
 * */
@AdvancedFeignClient
public interface RemoteManagerMarketDataService {

    /**
     * 查询营销数据明细列表支持分页和不分页
     * @param pageSize 页面大小 可空，空则不分页
     * @param pageNum 页码 可空，空则不分页
     * @param configId 配置主键id
     * @param organNum 机构编号
     * @param staffNum 员工编号
     * @param taskId 任务id
     * @param startDate 开始时间 yyyy-MM-dd
     * @param endDate 结束时间 yyyy-MM-dd
     * */
    List<ManagerMarketStatisticsDataDto> marketDataDetailList(Long configId,String startDate,String endDate
            ,String taskId,String staffNum,String organNum,Integer pageSize,Integer pageNum);
    /**
     * 查询营销数据明细列表总数
     * @param configId 配置主键id
     * @param organNum 机构编号
     * @param staffNum 员工编号
     * @param taskId 任务id
     * @param startDate 开始时间 yyyy-MM-dd
     * @param endDate 结束时间 yyyy-MM-dd
     * */
    long marketDataDetailListCount(Long configId,String startDate,String endDate
            ,String taskId,String staffNum,String organNum);
    /**
     *任务推广情况列表支持分页和不分页
     *
     * @param pageSize 页面大小 可空，空则不分页
     * @param pageNum 页码 可空，空则不分页
     * @param configId 配置主键id
     * @param startDate 开始时间 yyyy-MM-dd
     * @param endDate 结束时间 yyyy-MM-dd
     * */
    List<ManagerMarketStatisticsDataDto> taskPromotionDataList(Long configId,String startDate,String endDate
            ,Integer pageSize,Integer pageNum);
    /**
     *任务推广情况列表总数
     * @param configId 配置主键id
     * @param startDate 开始时间 yyyy-MM-dd
     * @param endDate 结束时间 yyyy-MM-dd
     * */
    long taskPromotionDataListCount(Long configId,String startDate,String endDate);

    /**
     * 单营销任务转发排名列表支持分页和不分页
     * @param pageSize 页面大小 可空，空则不分页
     * @param pageNum 页码 可空，空则不分页
     * @param configId 配置主键id
     * @param taskId 任务id
     * @param rankBy 排序方式 1机构，2员工
     * */
    List<ManagerMarketStatisticsDataDto> taskForwardRankList(String taskId,Integer rankBy,Long configId
            ,Integer pageSize,Integer pageNum);
    /**
     * 单营销任务转发排名列表总数
     * @param configId 配置主键id
     * @param taskId 任务id
     * @param rankBy 排序方式 1机构，2员工
     * */
    long taskForwardRankListCount(String taskId,Integer rankBy,Long configId);

    /**
     * 员工/机构转发排名 列表支持分页和不分页

     * @param pageSize 页面大小 可空，空则不分页
     * @param pageNum 页码 可空，空则不分页
     * @param timeNum 第几周或第几月
     * @param sortNum 排名时间，1按月，2按周
     * @param rankBy 排序方式 1机构，2员工
     * */
    List<ManagerMarketRankDto> staffForwardRankList(Long configId,Integer year,Integer timeNum,Integer sortNum,Integer rankBy
            ,Integer pageSize,Integer pageNum);
    /**
     * 员工/机构转发排名 总数
     * @param timeNum 第几周或第几月
     * @param sortNum 排名时间，1按月，2按周
     * @param rankBy 排序方式 1机构，2员工
     * */
    long staffForwardRankListCount(Long configId,Integer year,Integer timeNum,Integer sortNum,Integer rankBy);
    /**
     * 插入统计数据
     * @param dto 计算好的统计数据
     * */
    int insertStatisticsData(ManagerMarketStatisticsDataDto dto);

    /**
     * 提供给定时任务调用的统计方法
     */
    void doManagerMarketStatistic();


}
