package cn.com.duiba.activity.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by fangdong on 2019/03/28
 */
public enum HappyCodeFallbackTypeEnum {

    NONE_AWARD(1, "不中奖"),
    OTHER_AWARD(2, "其他奖项"),
    ;

    /**
     * value
     */
    private Integer value;
    /**
     * 描述
     */
    private String desc;

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    HappyCodeFallbackTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static Map<Integer, HappyCodeFallbackTypeEnum> valueMap = new HashMap<>();

    static {
        for (HappyCodeFallbackTypeEnum typeEnum : values()) {
            valueMap.put(typeEnum.getValue(), typeEnum);
        }
    }

    public static HappyCodeFallbackTypeEnum getByValue(Integer value) {
        return valueMap.get(value);
    }

}
