package cn.com.duiba.activity.center.api.enums.richman;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 大富翁 达到终点事件
 * @author 歪大哥😁
 * @date 2020-08-14.
 */
public enum RichManArriveEndingEventEnum {

    NOTHING(1, "站着别动"),

    RESTART(2, "送你回家"),
    ;

    private int code;

    private String desc;


    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


    RichManArriveEndingEventEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer, RichManArriveEndingEventEnum> map;

    static {
        Map<Integer, RichManArriveEndingEventEnum> temp = Maps.newHashMap();

        for (RichManArriveEndingEventEnum value : values()) {
            temp.put(value.code, value);
        }
        map = temp;
    }

    public static RichManArriveEndingEventEnum getByCode(Integer code) {
        return map.get(code);
    }

}
