package cn.com.duiba.activity.center.api.remoteservice.anticheat;

import cn.com.duiba.activity.center.api.dto.anticheat.AntiCheatExchangeDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 从duiba-service迁移过来
 */
@AdvancedFeignClient
public interface RemoteExchangeLimitService {

    /**
     * selectExchangeLimit:直充类奖品防刷验证.
     *
     * @param appId               应用id									not null
     * @param operatingActivityId 活动id								not null
     * @param type                奖品类型									not null
     * @param account             领奖账号									not null
     * @return
     * @author guoeryang
     * @since JDK 1.6
     */
    DubboResult<Long> checkExchangeLimit(Long appId, Long operatingActivityId, String type, String account);

    /**
     * selectExchangeLimit:直充类奖品防刷验证记录创建.
     *
     * @param appId               应用id									not null
     * @param operatingActivityId 活动id								not null
     * @param consumerId          用户id									not null
     * @param type                奖品类型									not null
     * @param account             领奖账号									not null
     * @return
     * @author guoeryang
     * @since JDK 1.6
     */
    void createExchangeLimitRecord(Long appId, Long operatingActivityId, Long consumerId, String type, String account);

    /**
     * selectExchangeLimit:直充类奖品防刷  用户与账户 绑定关系解除.
     *
     * @param type                奖品类型									not null
     * @param appId               应用id									not null
     * @param operatingActivityId 活动id									not null
     * @param account             领奖账号										not null
     * @return
     * @author guoeryang
     * @since JDK 1.6
     */
    void dataBackExchangeLimit(Long appId, String type, Long operatingActivityId, String account);

    /**
     * selectExchangeLimit:直充类奖品防刷验证.
     *
     * @param appId               应用id                                    not null
     * @param operatingActivityId 活动id                               not null
     * @param type                奖品类型                                   not null
     * @param account             领奖账号                                 not null
     * @return
     * @author guoeryang
     * @since JDK 1.6
     */
    DubboResult<Long> checkExchangeLimitType(Long appId, Long operatingActivityId, String type, String account, String activityType);

    /**
     * selectExchangeLimit:直充类奖品防刷验证记录创建.
     *
     * @param appId               应用id                                    not null
     * @param operatingActivityId 活动id                               not null
     * @param consumerId          用户id                                    not null
     * @param type                奖品类型                                   not null
     * @param account             领奖账号                                 not null
     * @return
     * @author guoeryang
     * @since JDK 1.6
     */
    void createExchangeLimitRecordType(Long appId, Long operatingActivityId, Long consumerId, String type, String account, String activityType);

    /**
     * selectExchangeLimit:直充类奖品防刷  用户与账户 绑定关系解除.
     *
     * @param type                奖品类型                                   not null
     * @param appId               应用id                                    not null
     * @param operatingActivityId 活动id                                   not null
     * @param account             领奖账号                                     not null
     * @return
     * @author guoeryang
     * @since JDK 1.6
     */
    void dataBackExchangeLimitType(Long appId, String type, Long operatingActivityId, String account, String activityType);


    /**
     * 防刷校验
     * 应用id appId;
     * 用户id consumerId;
     * 用户领奖账号  account;
     * 奖项类型 prizeType;
     * 活动类型 activityType;
     * 活动id activityId;
     * @param antiCheatExchangeDto
     * @return
     */
    boolean antiBrushCheck(AntiCheatExchangeDto antiCheatExchangeDto);

    /**
     * 支付宝类型防刷校验
     * @param appId
     * @param operatingActivityId
     * @param account
     * @return
     * @throws BizException
     */
    List<Long> checkExchangeLimitTypeWithAccountCheck(Long appId, Long operatingActivityId, String type, String account, String activityType) throws BizException;


}
