package cn.com.duiba.activity.center.api.dto.miningmachine;

import java.io.Serializable;
import java.util.Date;

/**
 * @program: activity-all
 * @description: 挖矿机活动配置
 * @author: Simba
 * @create: 2019-04-29 15:54
 **/
public class MiningMachineDto implements Serializable {

    private static final long serialVersionUID = 7445881658252596552L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 标题
     */
    private String title;

    /**
     * 活动规则
     */
    private String rule;

    /**
     * 活动开始时间
     */
    private Date startTime;

    /**
     * 活动结束时间
     */
    private Date endTime;

    /**
     * banner图
     */
    private String bannerImage;

    /**
     * 缩略图
     */
    private String smallImage;

    /**
     * 入库活动id
     */
    private Long operatingActivityId;

    /**
     * 挖矿消耗
     */
    private Long miningExpend;

    /**
     * pk消耗
     */
    private Long pkExpend;

    /**
     * 积分回收率
     */
    private Integer recoveryRate;

    /**
     * 是否展示积分（1：展示；2：不展示）
     */
    private Integer showCredits;

    /**
     * 界面配置数据
     */
    private String dataJson;

    /**
     * 删除标识 （0：未删除，1：删除）默认为0
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getRule() {
        return rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getBannerImage() {
        return bannerImage;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public String getSmallImage() {
        return smallImage;
    }

    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public Long getMiningExpend() {
        return miningExpend;
    }

    public void setMiningExpend(Long miningExpend) {
        this.miningExpend = miningExpend;
    }

    public Long getPkExpend() {
        return pkExpend;
    }

    public void setPkExpend(Long pkExpend) {
        this.pkExpend = pkExpend;
    }

    public Integer getRecoveryRate() {
        return recoveryRate;
    }

    public void setRecoveryRate(Integer recoveryRate) {
        this.recoveryRate = recoveryRate;
    }

    public Integer getShowCredits() {
        return showCredits;
    }

    public void setShowCredits(Integer showCredits) {
        this.showCredits = showCredits;
    }

    public String getDataJson() {
        return dataJson;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

