package cn.com.duiba.activity.center.api.remoteservice.happygroup;

import cn.com.duiba.activity.center.api.dto.happygroup.HappyGroupRecordDto;
import cn.com.duiba.activity.center.api.params.HappyGroupRecordPageParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;
import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/2/28 11:59
 * @description: 拼拼乐活动用户参团记录
 */
@AdvancedFeignClient
public interface RemoteHappyGroupRecordAppService {

	/**
	 * 新增参团记录
	 */
	int add(HappyGroupRecordDto entity);

	/**
	 * 根据参团记录id更新记录状态
	 */
	int modifyStatusById(Long id, int recordStatus, String winOrderNum);

	/**
	 * 按团id获取团长id
	 */
	Long getOwnerByGroupId(Long groupInfoId);

	/**
	 * 按团id和数量批量获取团员id
	 */
	List<Long> getMembersByGroupId(Long groupInfoId, int limitCount);

	/**
	 * 根据用户id获取用户所有可领奖状态的参团记录
	 */
	List<HappyGroupRecordDto> getExchangeWaitingList(Long consumerId);

	/**
	 * 根据拼团活动配置id、用户id及是否团长，获取用户在对应拼团活动的参团数量
	 * @param groupConfigId 必传
	 * @param consumerId 必传
	 * @param ownerType 非必传：不传则包括开团和参团；传1，是团长，代表开团；传2，不是团长，代表参团
	 * @param gmtCreate 非必传：不传则为总共参与次数
	 * @return
	 */
	Integer getCountByConfigAndCIdAndType(Long groupConfigId, Long consumerId, Integer ownerType, Date gmtCreate) throws BizException;

	/**
	 * 根据拼团商品id、用户id及是否团长，获取用户在对应拼团商品的参团数量
	 * @param itemId 必传
	 * @param consumerId 必传
	 * @param ownerType 非必传：不传则包括开团和参团；传1，是团长，代表开团；传2，不是团长，代表参团
	 * @param gmtCreate 非必传：不传则为总共参与次数
	 * @return
	 */
	Integer getCountByItemAndCIdAndType(Long itemId, Long consumerId, Integer ownerType, Date gmtCreate) throws BizException;

	/**
	 * 根据拼团商品id、用户id，获取用户在对应拼团商品下是否有进行中的参团记录
	 */
	Boolean checkUnderWayGroupByItem(Long groupItemId, Long consumerId) throws BizException;

	/**
	 * 根据拼团商品idlist、用户id，获取用户在对应拼团商品下的进行中的参团记录
	 */
	List<HappyGroupRecordDto> getUnderWayGroupByItems(List<Long> groupItemIds, Long consumerId) throws BizException;

	/**
	 * 根据团id和用户id获取用户在该团的参与记录
	 * @param groupId
	 * @param consumerId
	 * @return
	 */
	HappyGroupRecordDto getByGroupIdAndConsumerId(Long groupId, Long consumerId) throws BizException;

	/**
	 * 按appid、拼团活动配置id、用户id批量获取参团记录
	 */
	List<HappyGroupRecordDto> getPage(HappyGroupRecordPageParam happyGroupRecordPageParam);

	/**
	 * 根据团id获取团员数量
	 */
	Integer getCountByGroupId(Long groupId);
}
