package cn.com.duiba.activity.center.api.remoteservice.equity;

import cn.com.duiba.activity.center.api.dto.equity.EquityXiAnGiftPackDto;
import cn.com.duiba.activity.center.api.request.equity.XiAnGiftPackRequest;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author haojiahong
 * @date 2021-08-25
 */
@AdvancedFeignClient
public interface RemoteEquityXiAnGiftPackService {

    /**
     * 通过权益id，查询此权益下的礼包集合
     *
     * @param equityId
     * @return
     */
    List<EquityXiAnGiftPackDto> listByEquityId(Long equityId);

    /**
     * 删除某个权益下的所有礼包
     *
     * @param equityId
     * @return
     */
    Integer deleteByEquityId(Long equityId);

    /**
     * 新增or更新权益礼包
     *
     * @param equityId
     * @param requestList
     * @return
     */
    Integer saveOrUpdateXiAnGiftPack(Long equityId, List<XiAnGiftPackRequest> requestList);


}
