package cn.com.duiba.activity.center.api.remoteservice.centscan;

import cn.com.duiba.activity.center.api.dto.centscan.CentscanPrizeConfigDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 一分扫奖品配置-远程服务接口
 *
 * @Author: xuwei
 * @Date: 2020/07/03
 */
@AdvancedFeignClient
public interface RemoteCentscanPrizeConfigService {

    CentscanPrizeConfigDto findById(Long id);

    List<CentscanPrizeConfigDto> findByConfigId(Long configId);

    List<CentscanPrizeConfigDto> findByConfigIdAndAppItemIds(Long configId, List<Long> appItemIds);

    void batchInsertOrUpdate(List<CentscanPrizeConfigDto> records);

    void deleteByIds(List<Long> ids);
}