package cn.com.duiba.activity.center.api.remoteservice.game;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerAppSpecifyDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteDuibaQuestionAnswerAppSpecifyService {

	/**
	 * 
	 * findByQuestionAnswerIdAndAppId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionId
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	DuibaQuestionAnswerAppSpecifyDto findByQuestionAnswerIdAndAppId(Long questionId, Long appId);
	/**
	 * 
	 * findByQuestionAnswerIdsAndAppId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionIds
	 * @param appId
	 * @return
	 * @since JDK 1.6
	 */
	Map<Long, DuibaQuestionAnswerAppSpecifyDto> findByQuestionAnswerIdsAndAppId(List<Long> questionIds, Long appId);

	/**
	 * 
	 * findByDuibaQuestionAnswerId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaQuestionAnswerId
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaQuestionAnswerAppSpecifyDto> findByDuibaQuestionAnswerId(Long duibaQuestionAnswerId);

	/**
	 * 
	 * delete:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @since JDK 1.6
	 */
	public void delete(Long id);

	/**
	 * 
	 * insert:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param duibaQuestionAnswerAppSpecify
	 * @since JDK 1.6
	 */
	public void insert(DuibaQuestionAnswerAppSpecifyDto duibaQuestionAnswerAppSpecify);

	/**
	 * 
	 * find:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaQuestionAnswerAppSpecifyDto find(Long id);
}
