package cn.com.duiba.activity.center.api.remoteservice.label;

import cn.com.duiba.activity.center.api.dto.label.ConsumerLabelDetailDto;
import cn.com.duiba.activity.center.api.dto.label.ConsumerLabelDto;
import cn.com.duiba.activity.center.api.dto.label.ConsumerLabelStrategyDto;
import cn.com.duiba.activity.center.api.remoteservice.label.param.LabelPassBaseParam;
import cn.com.duiba.activity.center.api.remoteservice.label.param.LabelPassGoodsFilterParam;
import cn.com.duiba.activity.center.api.remoteservice.label.result.LabelPassResult;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.Pair;

import java.util.List;
import java.util.Set;

/**
 * @date: $ $
 * @auther: linzhou$
 * @description: TODO  $
 */
@AdvancedFeignClient
public interface RemoteConsumerLabelService {

    /**
     * 新增标签
     *
     * @param labelName
     * @param userIdMap
     * @return
     */
    Long insertLabel(Long appId, Long createId, String labelName, List<Pair<String, Set<String>>> userIdMap) throws BizException;


    /**
     * 修改标签
     *
     * @param labelId
     * @param labelName
     * @param userIdMap
     * @return
     */
    Boolean updateLabel(Long devId, Long labelId, String labelName, List<Pair<String, Set<String>>> userIdMap) throws BizException;

    /**
     * 删除标签
     *
     * @param labelId
     * @return
     */
    Boolean delLabel(List<Long> idList) throws BizException;

    /**
     * 增加标签内的用户
     *
     * @param labelId
     * @param userIdMap
     * @return
     */
    Boolean saveUserId(Long createId, Long labelId, List<Pair<String, Set<String>>> userIdMap) throws BizException;

    /**
     * 查询当前标签下的所有用户id
     *
     * @param labelId
     * @return
     */
    Set<String> getHistoryUserIds(Long labelId);

    /**
     * 查询标签明细
     *
     * @param labelId
     * @param userId
     * @return
     */
    List<ConsumerLabelDetailDto> selectLabelDetails(Long labelId, String userId, Integer pageNo, Integer pageSize);

    /**
     * 查询标签
     *
     * @param curAppId
     * @param labelName
     * @return
     */
    List<ConsumerLabelDto> selectLabels(Long curAppId, String labelName, Integer pageNo, Integer pageSize);

    /**
     * 查询标签详情
     *
     * @param labelId
     * @return
     */
    ConsumerLabelDto selectLabel(Long labelId);

    /**
     * 用户标签策略查询
     *
     * @param curAppId
     * @param strategyType
     * @param strategyName
     * @param strategyStatus
     * @return
     */
    List<ConsumerLabelStrategyDto> selectLabelStrategy(Long curAppId,
                                                       String strategyType, String strategyName, String strategyStatus,
                                                       Integer pageNo, Integer pageSize);


    /**
     * 创建用户标签策略
     *
     * @param strategyType
     * @param strategyStatus
     * @param labelIdList
     * @param strategyContent
     * @return
     */
    Long insertLabelStrategy(Long devId, String strategyType, String strategyStatus, List<Long> labelIdList, String strategyContent) throws BizException;

    /**
     * 创建用户标签策略 dto
     * @param dto
     * @return
     */
    Long insertLabelStrategyDto(ConsumerLabelStrategyDto dto) throws BizException;

    /**
     * 修改用户标签策略
     *
     * @param id
     * @param strategyType
     * @param strategyStatus
     * @param labelIdList
     * @param strategyContent
     * @return
     */
    Boolean updateLabelStrategy(Long devId, Long id, String strategyType, String strategyStatus, List<Long> labelIdList, String strategyContent) throws BizException;

    /**
     * 修改用户标签策略 dto
     * @param dto
     * @return
     */
    Boolean updateLabelStrategyDto(ConsumerLabelStrategyDto dto) throws BizException;

    /**
     * 删除指定id的用户标签策略
     *
     * @param id
     * @return
     */
    Boolean delLabelStrategy(List<Long> idList);

    /**
     * @param labelId
     * @param userId
     * @return
     */
    Integer selectCountLabelDetails(Long labelId, String userId);

    /**
     * @param curAppId
     * @param labelName
     * @return
     */
    Integer selectCountLabels(Long curAppId, String labelName);

    /**
     * @param curAppId
     * @param strategyType
     * @param strategyName
     * @param strategyStatus
     * @return
     */
    Integer selectCountLabelStrategy(Long curAppId, String strategyType, String strategyName, String strategyStatus);


    /**
     * 策略信息详情查询
     *
     * @param strategyId
     * @return
     */
    ConsumerLabelStrategyDto getLabelInfoStrategy(Long strategyId);

    /**
     * 校验是否通过当前的用户标签
     * @param param
     * @return
     */
    LabelPassResult isPass(LabelPassBaseParam param);

    /**
     * 白名单策略-用户点击商品弹窗信息
     * @param appId
     * @param userId
     * @param appItemId
     * @return
     */
    ConsumerLabelStrategyDto selectPopConfig(Long appId,String userId,Long appItemId);

    /**
     * 白名单策略-用户点击商品弹窗信息
     * @param appId
     * @param userId
     * @param strategyContent
     * @return
     */
    ConsumerLabelStrategyDto getPopConfig(Long appId,String userId,String strategyContent);
}
