package cn.com.duiba.activity.center.api.dto.activity;

import cn.com.duiba.activity.center.api.dto.BaseDto;
import cn.com.duiba.activity.center.api.enums.CLRewardRuleMatchEnum;
import cn.com.duiba.activity.center.api.enums.RewardTypeEnum;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 奖项配置
 * Created by xiaoxuda on 2017/10/25.
 */
public class CLRewardDto extends BaseDto {
    private static final long serialVersionUID = 7950283593032350516L;
    /**
     * 奖项等级，默认按奖项顺序从1开始,数字越小等级越高，非空
     */
    @NotNull(message = "奖项等级不能为null")
    private Integer grade;
    /**
     * 奖项名称
     */
    @NotBlank(message = "奖项名称不能为空")
    private String name;
    /**
     * 出奖方式
     */
    @NotNull(message = "出奖方式不能为null")
    private RewardTypeEnum rdType;
    /**
     * 出奖方式关联类型
     */
    @NotBlank(message = "奖品类型不能为空")
    private String rlType;
    /**
     * 出奖方式关联ID
     */
    @NotNull(message = "奖品ID不能为null")
    private Long rlId;
    /**
     * 奖品名称
     */
    private String rlName;
    /**
     * 奖品面值，已分为单位
     */
    private Integer rlPrice;

    /**
     * 虚拟商品档位（若奖品为开发者的虚拟商品，则用此字段存储档位）
     */
    private String rlGear;
    /**
     * 奖品展示图片
     */
    private String prizeImg;
    /**
     * 奖品名称
     */
    private String prizeName;
    /**
     * 奖项匹配规则集合
     */
    @Size(min = 1, message = "奖项规则集合不能为空")
    private List<Entry> matchs;
    /**
     * 中奖匹配规则
     */
    private CLRewardRuleMatchEnum matchType = CLRewardRuleMatchEnum.ALL_MATCH;
    /**
     * 是否开启兑换次数限制
     */
    @NotNull(message = "兑换次数限制不能为null")
    private Boolean amountsLimit = true;
    /**
     * 允许的兑换次数，amountsLimit==true时必填且大于0
     */
    private Long limitCount = 1L;
    /**
     * 是否开启库存限制
     */
    @NotNull(message = "库存限制不能为null")
    private Boolean stockLimit;
    /**
     * 奖项可用库存，stockLimit==true时必填
     */
    private Long stock;
    /**
     * 库存中心ID
     */
    private Long stockId;
    /**
     * 随机卡数量
     */
    private Integer entryCount;
    /**
     * 奖项是否 自动开奖   
     * true  自动开奖
     * false  非自动开奖
     */
    private Boolean autoReward = true;
    /**
     * 奖项是否 自动开奖   
     * true  自动开奖
     * false  非自动开奖
     */
    private Boolean isOpen = false;

    public Boolean getIsOpen() {
		return isOpen;
	}

	public void setIsOpen(Boolean isOpen) {
		this.isOpen = isOpen;
	}

	public Integer getEntryCount() {
		return entryCount;
	}

	public void setEntryCount(Integer entryCount) {
		this.entryCount = entryCount;
	}

	public Boolean getAutoReward() {
		return autoReward;
	}

	public void setAutoReward(Boolean autoReward) {
		this.autoReward = autoReward;
	}

    public static class Entry implements Serializable {
        private static final long serialVersionUID = -4971741811275564470L;

        @NotBlank(message = "key不能为空")
        private String key;
        @NotNull(message = "entry值不能为null")
        private Integer val;

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Integer getVal() {
            return val;
        }

        public void setVal(Integer val) {
            this.val = val;
        }
    }

    public RewardTypeEnum getRdType() {
        return rdType;
    }

    public void setRdType(RewardTypeEnum rdType) {
        this.rdType = rdType;
    }

    public String getRlType() {
        return rlType;
    }

    public void setRlType(String rlType) {
        this.rlType = rlType;
    }

    public Long getRlId() {
        return rlId;
    }

    public void setRlId(Long rlId) {
        this.rlId = rlId;
    }

    public String getRlName() {
        return rlName;
    }

    public void setRlName(String rlName) {
        this.rlName = rlName;
    }

    public Integer getRlPrice() {
        return rlPrice;
    }

    public void setRlPrice(Integer rlPrice) {
        this.rlPrice = rlPrice;
    }

    public String getPrizeImg() {
        return prizeImg;
    }

    public void setPrizeImg(String prizeImg) {
        this.prizeImg = prizeImg;
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public List<Entry> getMatchs() {
        return matchs;
    }

    public void setMatchs(List<Entry> matchs) {
        this.matchs = matchs;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CLRewardRuleMatchEnum getMatchType() {
        return matchType;
    }

    public void setMatchType(CLRewardRuleMatchEnum matchType) {
        this.matchType = matchType;
    }

    public Boolean getAmountsLimit() {
        return amountsLimit;
    }

    public void setAmountsLimit(Boolean amountsLimit) {
        this.amountsLimit = amountsLimit;
    }

    public Long getLimitCount() {
        return limitCount;
    }

    public void setLimitCount(Long limitCount) {
        this.limitCount = limitCount;
    }

    public Boolean getStockLimit() {
        return stockLimit;
    }

    public void setStockLimit(Boolean stockLimit) {
        this.stockLimit = stockLimit;
    }

    public Long getStock() {
        return stock;
    }

    public void setStock(Long stock) {
        this.stock = stock;
    }

    public Long getStockId() {
        return stockId;
    }

    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }

    public String getRlGear() {
        return rlGear;
    }

    public void setRlGear(String rlGear) {
        this.rlGear = rlGear;
    }
}
