package cn.com.duiba.activity.center.api.dto.sign;

import cn.com.duiba.activity.center.api.enums.SignSpecDayRewardTypeEnum;

/**
 * 特定日期签到奖励配置条目
 * Created by xiaoxuda on 2017/12/12.
 */
public class SignRewardRuleItem4SpecDayDto extends SignRewardRuleItemDto {
    /**
     * 奖励方式
     */
    private SignSpecDayRewardTypeEnum rwType;

    /**
     * 计算特殊日期奖励
     * @param addCredits
     * @param addCount
     * @return
     */
    public SignRewardRuleItemDto calculateReward(Integer addCredits, Integer addCount){
        SignRewardRuleItemDto item = new SignRewardRuleItemDto();
        if(SignSpecDayRewardTypeEnum.DOUBLE.equals(rwType)){
            item.setCredits(addCredits * 2);
            item.setActivityCount(addCount * 2);
        }else if(SignSpecDayRewardTypeEnum.CUSTOM_EXTRA.equals(rwType)){
            item.setCredits(this.getCredits());
            item.setActivityCount(this.getActivityCount());
        }
        return item;
    }

    public SignSpecDayRewardTypeEnum getRwType() {
        return rwType;
    }

    public void setRwType(SignSpecDayRewardTypeEnum rwType) {
        this.rwType = rwType;
    }
}
