package cn.com.duiba.activity.center.api.dto.lottery;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/05/31
 */
public class LotteryBetDto implements Serializable {
    private static final long serialVersionUID = 3833779155581133877L;

    public static final int    STATUS_NOCOMPLETE      = 0;                    // 未结算
    public static final int    STATUS_OPEN            = 1;                    // 已结算
    public static final int    STATUS_CLOSE_SHOW      = 2;                    // 退单

    public static final int    SWITCHES_DIRECT        = 0;                     // 定向发放
    public static final int    SWITCHES_DEV_BLACKLIST = 1;                     // 黑名单

    //主键自增
    private Long id;

    //活动名称（用于管理端的名称显示）
    private String title;

    //活动标题（用于显示在手机端的活动标题）
    private String betName;

    //投注开始时间
    private Date beginTime;

    //投注结束时间
    private Date endTime;

    //结算状态：0，可以押注； 1，已开奖；
    private Integer betStatus;

    //参与方式：1，自由投注；2，固定值
    private Integer betType;

    //如果参与方式是自由投注，则为用户最高总投注积分价值；如果参与方式是固定值，则为指定投注积分价值
    private Integer limitCredits;

    //投注结果选项id
    private Long betResult;

    //投注结果说明
    private String betResultDesc;

    //是否删除：0，否；1，是
    private Integer deleted;

    private List<LotteryBetOptionDto> lotteryBetOptions;

    //押注的总积分
    private Integer betTotal;

    public Integer getBetTotal() {
        return betTotal;
    }

    public void setBetTotal(Integer betTotal) {
        this.betTotal = betTotal;
    }

    private Integer            switches;

    /**
     *
     * openSwitch:(这里用一句话描述这个方法的作用). <br/>
     * @param s
     * @since JDK 1.6
     */
    public void openSwitch(int s) {
        int v = 1 << s;
        switches = switches | v;
    }

    /**
     *
     * closeSwitch:(这里用一句话描述这个方法的作用). <br/>
     * @param s
     * @since JDK 1.6
     */
    public void closeSwitch(int s) {
        int v = 1 << s;
        v = ~v;
        switches = switches & v;
    }

    /**
     *
     * isOpenSwitch:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param s
     * @return
     * @since JDK 1.6
     */
    public boolean isOpenSwitch(int s) {
        int v = 1 << s;
        int ret = switches & v;
        return ret != 0;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBetName() {
        return betName;
    }

    public void setBetName(String betName) {
        this.betName = betName;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getBetStatus() {
        return betStatus;
    }

    public void setBetStatus(Integer betStatus) {
        this.betStatus = betStatus;
    }

    public Integer getBetType() {
        return betType;
    }

    public void setBetType(Integer betType) {
        this.betType = betType;
    }

    public Integer getLimitCredits() {
        return limitCredits;
    }

    public void setLimitCredits(Integer limitCredits) {
        this.limitCredits = limitCredits;
    }

    public Long getBetResult() {
        return betResult;
    }

    public void setBetResult(Long betResult) {
        this.betResult = betResult;
    }

    public String getBetResultDesc() {
        return betResultDesc;
    }

    public void setBetResultDesc(String betResultDesc) {
        this.betResultDesc = betResultDesc;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public List<LotteryBetOptionDto> getLotteryBetOptions() {
        return lotteryBetOptions;
    }

    public void setLotteryBetOptions(List<LotteryBetOptionDto> lotteryBetOptions) {
        this.lotteryBetOptions = lotteryBetOptions;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Integer getSwitches() {
        return switches;
    }

    public void setSwitches(Integer switches) {
        this.switches = switches;
    }
}
