package cn.com.duiba.activity.center.api.remoteservice.betv2;

import cn.com.duiba.activity.center.api.dto.betv2.BetV2ListRecordDto;
import cn.com.duiba.activity.center.api.dto.betv2.BetV2RecordDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * RemoteBetV2RecordService
 *
 * @author ChenXiangge
 * @date 28/06/2018
 */
@AdvancedFeignClient
public interface RemoteBetV2RecordService {

    /**
     * 往日胜利战绩
     * @param consumerId
     * @param appId
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<BetV2ListRecordDto> list(Long consumerId, Long appId, Integer pageNo, Integer pageSize);

    /**
     * 活动用户参与pk活动的次数
     * @param consumerId  用户id
     * @return 押注的总次数
     */
    Long findBetTimesByConsumerId(Long consumerId);

    /**
     * 是否可以插件抽奖
     * @param betId pk赛活动
     * @param consumerId 用户id
     * @return 是否可以插件抽奖
     */
    Boolean ifICanDraw(Long betId, Long consumerId);

   /**
     * 汇总活动下用户，已押注题目的总金额（包括未开奖的）
     * @param betIds 押注题目的id集合
     * @param appId
     * @return
     */
    Integer getTotalMoneyByConusmer(Long appId,List<Long> betIds,Long consumerId) throws BizException;

    /**
     * 查询各选项押注数量
     * @param appId
     * @param betId
     * @param optionId
     * @return
     */
    Long getBetTimesFromDB(Long appId, Long betId, Long optionId);

    /**
     * pk赛独立活动加钱
     * @param consumerId
     * @param actGroupId
     */
    Long addRedPacket4Consumer(Long consumerId, Long actGroupId, Long appId);

    /**
     * pk赛独立活动战绩页面
     * @param consumerId
     * @param actGroupId
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<BetV2ListRecordDto> listByActGroupId(Long consumerId, Long actGroupId, Integer pageNo, Integer pageSize);

    /**
     * pk赛独立活动战绩页面,可指定天数
     * @param consumerId
     * @param actGroupId
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<BetV2ListRecordDto> listByActGroupIdAndDays(Long consumerId, Long actGroupId, Integer days, Integer pageNo, Integer pageSize);

    Page<BetV2ListRecordDto> listByActGroupIds(Long consumerId, List<Long> actGroupIds, Integer pageNo, Integer pageSize);

    void updateExchangeStatusById(Long recordId, int exchangeStatus);

    BetV2RecordDto findById(Long recordId);

}
