package cn.com.duiba.activity.center.api.dto.bet;

import cn.com.duiba.activity.center.api.enums.BetActivityBonusTypeNum;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhangruofan
 * @date 2018/04/28
 */
public class BetActGroupDto implements Serializable {
    private static final long serialVersionUID = -8827921420006790213L;
    private Long id;
    private String title;
    /**
     * AttributionTypeEnum
     */
    private Integer attributionType;

    private Long appId;
    /**
     * 周期id
     */
    private Long periodId;


    /**周期开始时间**/
    private Date periodStartTime;

    /**周期结束时间**/
    private Date periodEndTime;


    /**
     * 瓜分类型 1瓜分红包 2瓜分积分 3 瓜分红包或积分 4 瓜分H5 奖品
     */
    private BetActivityBonusTypeNum bonusType;

    /**
     * bonus_type必须为1或3有效）红包账户 1. 积分商城总账户 2  自定义账户
     */
    private Integer bonusAccount;

    /**
     * （bonus_type必须为1或3有效）每个用户可获得金额上限
     */
    private Integer bonusAmount;

    /**
     *（bonus_type必须为1或3有效）可提现人数
     */
    private Integer bonusSizeLimit;

    /**创建时间**/
    private Date gmtCreate;

    /**更新时间**/
    private Date gmtModified;

    /**页面配置**/
    private String styleConf;

    // 活动是否开启直冲防刷
    private boolean openBrush;

    public boolean isOpenBrush() {
        return openBrush;
    }

    public void setOpenBrush(boolean openBrush) {
        this.openBrush = openBrush;
    }


    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getAttributionType() {
        return attributionType;
    }

    public void setAttributionType(Integer attributionType) {
        this.attributionType = attributionType;
    }

    public Long getPeriodId() {
        return periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public BetActivityBonusTypeNum getBonusType() {
        return bonusType;
    }

    public void setBonusType(BetActivityBonusTypeNum bonusType) {
        this.bonusType = bonusType;
    }

    public Integer getBonusAccount() {
        return bonusAccount;
    }

    public void setBonusAccount(Integer bonusAccount) {
        this.bonusAccount = bonusAccount;
    }

    public Integer getBonusAmount() {
        return bonusAmount;
    }

    public void setBonusAmount(Integer bonusAmount) {
        this.bonusAmount = bonusAmount;
    }

    public Integer getBonusSizeLimit() {
        return bonusSizeLimit;
    }

    public void setBonusSizeLimit(Integer bonusSizeLimit) {
        this.bonusSizeLimit = bonusSizeLimit;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public Date getPeriodStartTime() {
        return periodStartTime;
    }

    public void setPeriodStartTime(Date periodStartTime) {
        this.periodStartTime = periodStartTime;
    }

    public Date getPeriodEndTime() {
        return periodEndTime;
    }

    public void setPeriodEndTime(Date periodEndTime) {
        this.periodEndTime = periodEndTime;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getStyleConf() {
        return styleConf;
    }

    public void setStyleConf(String styleConf) {
        this.styleConf = styleConf;
    }
}
