package cn.com.duiba.activity.center.api.remoteservice.alipayactivityredpack;

import cn.com.duiba.activity.center.api.dto.alipayactivityredpack.AlipayActivityConfigDto;
import cn.com.duiba.activity.center.api.enums.alipayactivityredpack.RedpackActivityStatusEnum;
import cn.com.duiba.activity.center.api.params.alipayactivityredpack.AlipayActivityConfigPageParam;
import cn.com.duiba.activity.center.api.params.alipayactivityredpack.AlipayActivityConfigParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author cjw
 * @version 1.0.0
 * @ClassName RemoteActivityConfig.java
 * @Description 支付宝链接券活动
 * @createTime 2022年11月17日 15:56:00
 */

@AdvancedFeignClient
public interface RemoteAlipayActivityConfigService {

    /**
     * 分页查询红包活动
     * @param alipayActivityConfigPageParam
     * @return
     */
    Page<AlipayActivityConfigDto> pageByParams(AlipayActivityConfigPageParam alipayActivityConfigPageParam);

    /**
     * 根据条件查询红包活动
     * @param alipayActivityConfigPageParam
     * @return
     */
    List<AlipayActivityConfigDto> queryByCondition(AlipayActivityConfigPageParam alipayActivityConfigPageParam);

    /**
     * 根据活动id修改活动状态,同时其活动下的链接卷转态也会改变
     * @param activityId-活动id redpackActivityStatusEnum-更改类型('0.正常  1.手动失效  2.自动结束')
     * @return
     */
    int updateActivityStatus(String activityId, RedpackActivityStatusEnum redpackActivityStatusEnum);


    /**
     * 根据活动id修改活动状态,同时其活动下的链接卷转态也会改变
     * @param activityId-活动id redpackActivityStatus-更改类型('0.正常  1.手动失效  2.自动结束')
     * @return
     */
    int updateToNoneByCreateing(String activityId);

    /**
     * 新建活动
     * @param alipayActivityConfigParam
     * @return
     */
    int createActivity(AlipayActivityConfigParam alipayActivityConfigParam);

    /**
     * 新建活动
     * @param alipayActivityConfigParam 活动参数
     * @return 主键ID
     */
    long createActivityEntity(AlipayActivityConfigParam alipayActivityConfigParam);


    /**
     * 判断该主体下的活动是否已经存在
     * @param activitySubject-活动主体 activityId-活动id
     * @return  true-已存在，false-不存在
     */
    Boolean activityExist(String activitySubject,String activityId);

    /**
     * 获取活动转态为正常但实际已过期的活动
     * @return
     */
    List<AlipayActivityConfigDto> activityListByOverdue();

    /**
     * 根据活动id获取活动状态
     * @param activityId 活动id
     * @return 活动状态
     */
    Integer getActivityState(String activityId);


    /**
     * 根据活动id修改活动信息
     * @param alipayActivityConfigDto
     * @return
     */
    int updateByActivityId(AlipayActivityConfigDto alipayActivityConfigDto);

    /**
     * 根据id修改活动ID
     * @param activityId 活动ID
     * @param id 主键ID
     */
    int updateIdAsActivityIdById(String activityId, Long id);

}
