package cn.com.duiba.activity.center.api.dto.openredpacket;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zhengjianhao
 * @date: 2019/4/28 11:44
 * @description: 拆红包工具-拆红包记录
 */
public class OpenRedPacketRecordDto implements Serializable {

	private static final long serialVersionUID = 4462980081850622486L;

	/**
	 * 主键id
	 */
	private Long id;

	/**
	 * appId
	 */
	private Long appId;

	/**
	 * 拆红包活动配置id
	 */
	private Long configId;

	/**
	 * 红包档位id
	 */
	private Integer gearId;

	/**
	 * 用户id
	 */
	private Long consumerId;

	/**
	 * uid
	 */
	private String partnerUserId;

	/**
	 * 需要邀请好友个数
	 */
	private Integer needFriendsNum;

	/**
	 * 红包总金额
	 */
	private Long totalAmount;

	/**
	 * 红包码
	 */
	private String shareCode;

	/**
	 * 拆红包状态：1，进行中；2，待领奖；3，已领奖；4，拆红包失败
	 * @see cn.com.duiba.activity.center.api.enums.OpenRedPacketRecordStatusEnum
	 */
	private Integer recordStatus;

	/**
	 * 创建时间
	 */
	private Date gmtCreate;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getConfigId() {
		return configId;
	}

	public void setConfigId(Long configId) {
		this.configId = configId;
	}

	public Integer getGearId() {
		return gearId;
	}

	public void setGearId(Integer gearId) {
		this.gearId = gearId;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public String getPartnerUserId() {
		return partnerUserId;
	}

	public void setPartnerUserId(String partnerUserId) {
		this.partnerUserId = partnerUserId;
	}

	public Integer getNeedFriendsNum() {
		return needFriendsNum;
	}

	public void setNeedFriendsNum(Integer needFriendsNum) {
		this.needFriendsNum = needFriendsNum;
	}

	public Long getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(Long totalAmount) {
		this.totalAmount = totalAmount;
	}

	public String getShareCode() {
		return shareCode;
	}

	public void setShareCode(String shareCode) {
		this.shareCode = shareCode;
	}

	public Integer getRecordStatus() {
		return recordStatus;
	}

	public void setRecordStatus(Integer recordStatus) {
		this.recordStatus = recordStatus;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}
}
