package cn.com.duiba.activity.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @auther: linjianhui
 * @date: 2018/12/17 16:00
 * @Description: 砍价订单状态枚举
 */
public enum BargainOrderStatusEnum {
    /**
     * 砍价中
     */
    INIT(1, "进行中"),

    /**
     * 砍价成功，未领取
     */
    SUCCESS(2, "未领取"),

    /**
     * 砍价成功，已领取商品
     */
    RECEIVED(3, "已领取"),

    /**
     * 超时，可重新砍价
     */
    TIME_OUT(4, "已超时"),

    /**
     * 超时，已针对此商品发起新的砍价
     */
    END(5, "已结束");

    private static Map<Integer, BargainOrderStatusEnum> statusEnumMap = new HashMap<>();

    static {
        for (BargainOrderStatusEnum statusEnum : BargainOrderStatusEnum.values()) {
            statusEnumMap.put(statusEnum.getCode(), statusEnum);
        }
    }

    private Integer code;
    private String desc;

    BargainOrderStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 通过code获取状态类型
     * @param code
     * @return
     */
    public static BargainOrderStatusEnum getByCode(int code) {
        BargainOrderStatusEnum status = statusEnumMap.get(code);
        if(status == null){
            return null;
        }
        return status;
    }
}
