package cn.com.duiba.activity.center.api.enums.haggle;

/**
 * @Author: lufeng
 * @Description: 砍价记录状态枚举
 * 砍价记录状态。1:正在砍，2:砍价失败，3:砍价成功未领取，4:砍价成功已领取
 * @Date: Created in 2019/9/23
 */
public enum RecordStatusEnum {

    WAITING(1, "正在砍"),
    FAIL(2, "砍价失败"),
    NORECEIVE(3, "砍价成功未领取"),
    RECEIVED(4, "砍价成功已领取"),
    RECEIVEFAIL(5, "砍价成功领取失败"),
    NOPRIZE(6, "已砍完");


    private Integer type;
    private String desc;

    RecordStatusEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
