package cn.com.duiba.activity.center.api.enums;

/**
 * ClassName:BookCheatEnum.java <br/>
 * 投票作弊类型枚举类
 *
 * @author xukaiqiang
 * @version 1.0
 * @date 创建时间：2018年06月13日 上午10:02:54
 * @since JDK 1.8
 */
public enum BookCheatEnum {

    PLUS(1, "加"),
    MINUS(2, "减");

    private Integer value;

    private String desc;

    BookCheatEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static boolean belong(Integer value) {
        for (BookCheatEnum bookCheat : BookCheatEnum.values()) {
            if (bookCheat.value.equals(value)) {
                return true;
            }
        }
        return false;
    }

}
