package cn.com.duiba.activity.center.api.remoteservice.superSurprise;

import cn.com.duiba.activity.center.api.dto.superSurprise.RankListProvidePrizeRecordDto;
import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseConfigDto;
import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseJoinRecordDto;
import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseJoinRecordQuery;
import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseRankListDto;
import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseRankListOptionDto;
import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseRebirthQueryDto;
import cn.com.duiba.activity.center.api.dto.superSurprise.SuperSurpriseRebirthRecordDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by zhangyongjie on 2022/3/23 2:26 下午
 * 【天降好礼】活动相关api
 */
@AdvancedFeignClient
public interface RemoteSuperSurpriseService {


    /**
     * 保存活动配置
     * @param superSurpriseConfigDto
     * @return
     */
    Long saveConfig(SuperSurpriseConfigDto superSurpriseConfigDto);


    /**
     * 根据id查找活动配置
     * @param id
     * @return
     */
    SuperSurpriseConfigDto getById(Long id);


    /**
     * 更新配置
     * @param superSurpriseConfigDto
     * @return
     */
    int updateConfig(SuperSurpriseConfigDto superSurpriseConfigDto);


    /**
     * 批量插入排行榜奖品
     * @param list
     */
    void batchInsertRankOption(List<SuperSurpriseRankListOptionDto> list);

    /**
     * 根据活动id和排名查找奖品
     * @param activityId
     * @param rank
     * @return
     */
    SuperSurpriseRankListOptionDto findByActivityIdAndRankRange(Long activityId, Integer rank);

    /**
     * 根据活动id删除排行榜奖品
     * @param activityId
     * @return
     */
    int deleteRankOptionByActivityId(Long activityId);


    /**
     * 根据活动id查询排行榜奖品
     * @param opId
     * @return
     */
    List<SuperSurpriseRankListOptionDto> findByOperatingActivityId(Long opId);


    /**
     * 保存参与记录
     * @param superSurpriseJoinRecordDto
     * @return
     */
    Long saveJoinRecord(SuperSurpriseJoinRecordDto superSurpriseJoinRecordDto);

    /**
     * 查询用户参与次数
     * @param query
     * @return
     */
    Integer countUserJoinTimes(SuperSurpriseJoinRecordQuery query);


    /**
     * 更新积分消耗状态
     * @param id
     * @param consumeCreditsStatus
     * @return
     */
    int updateCreditsStatusById(Long id, Integer consumeCreditsStatus);


    /**
     * 更新中奖状态
     * @param id
     * @param exchangeStatus
     * @return
     */
    int updateExchangeStatusById(Long id, Integer exchangeStatus);

    /**
     * 更新发奖状态
     * @param id
     * @param preExchangeStatus 原状态
     * @param newExchangeStatus 新状态
     * @return
     */
    int updateExchangeStatus(Long id, Integer preExchangeStatus, Integer newExchangeStatus);

    /**
     * 获取参与记录
     * @param id
     * @return
     */
    SuperSurpriseJoinRecordDto getJoinRecordById(Long id);


    /**
     * 更新参与记录
     * @param superSurpriseJoinRecordDto
     * @return
     */
    int updateJoinRecordById(SuperSurpriseJoinRecordDto superSurpriseJoinRecordDto);

    /**
     * 保存复活记录
     * @param superSurpriseRebirthRecordDto
     * @return
     */
    Long saveRebirthRecord(SuperSurpriseRebirthRecordDto superSurpriseRebirthRecordDto);


    /**
     * 根据id查询复活记录
     * @param id
     * @return
     */
    SuperSurpriseRebirthRecordDto findRebirthRecordById(Long id);


    /**
     * 更新复活记录
     * @param superSurpriseRebirthRecordDto
     * @return
     */
    int updateRebirthRecordById(SuperSurpriseRebirthRecordDto superSurpriseRebirthRecordDto);


    /**
     * 更新复活记录状态
     * @param id
     * @param status
     * @return
     */
    int updateRebirthStatus(Long id, Integer status);

    /**
     * 根据条件查询复活记录条数
     * @param superSurpriseRebirthQueryDto
     * @return
     */
    Integer countRebirthRecordByCondition(SuperSurpriseRebirthQueryDto superSurpriseRebirthQueryDto);


    /**
     * 保存排行榜
     * @param superSurpriseRankListDto
     * @return
     */
    Long saveRankList(SuperSurpriseRankListDto superSurpriseRankListDto);


    /**
     * 获取活动排行榜信息
     * @param activityId
     * @return
     */
    List<SuperSurpriseRankListDto> getRankInfo(Long activityId);


    /**
     * 获取自身排名
     * @param activityId
     * @param consumerId
     * @return
     */
    Integer getSelfRank(Long activityId, Long consumerId);

    /**
     * 获取自身排行榜记录
     * @param activityId
     * @param consumerId
     * @return
     */
    SuperSurpriseRankListDto getSelfRankRecord(Long activityId, Long consumerId);


    /**
     * 更新排行榜
     * @param superSurpriseRankListDto
     * @return
     */
    int updateRank(SuperSurpriseRankListDto superSurpriseRankListDto);

    /**
     * 更新排行榜
     * @param superSurpriseRankListDto
     * @return int
     */
    int increaseRankScore(SuperSurpriseRankListDto superSurpriseRankListDto);


    /**
     * 保存排行榜发奖记录
     * @param rankListProvidePrizeRecordDto
     * @return
     */
    Long saveRankProvidePrizeRecord(RankListProvidePrizeRecordDto rankListProvidePrizeRecordDto) throws BizException;


    /**
     * 根据活动id、活动类型和用户id查询排行榜发奖记录
     * @param activityId
     * @param type
     * @param consumerId
     * @return
     */
    RankListProvidePrizeRecordDto getRankProvidePrizeRecordByActIdAndTypeAndCid(Long activityId,String type,Long consumerId);


    /**
     * 根据id查询排行榜发奖记录
     * @param id
     * @return
     */
    RankListProvidePrizeRecordDto getByRankListProvidePrizeRecordId(Long id);


    /**
     * 更新排行榜发奖记录id
     * @param rankListProvidePrizeRecordDto
     * @return
     */
    int updateRankListProvidePrizeRecordById(RankListProvidePrizeRecordDto rankListProvidePrizeRecordDto);


    /**
     * 更新发奖记录状态
     * @param id
     * @param preStatus
     * @param newStatus
     * @return
     */
    int updateRankListProvidePrizeStatus(Long id,Integer preStatus, Integer newStatus);

    /**
     * 根据订单号查询排行榜发奖记录
     * @param orderNum
     * @return
     */
    RankListProvidePrizeRecordDto getRankListProvidePrizeRecordByOrderNum(String orderNum);


    /**
     * 根据订单号查询参与记录
     * @param orderNum
     * @return
     */
    SuperSurpriseJoinRecordDto findJoinRecordByOrderNum(String orderNum);
}