package cn.com.duiba.activity.center.api.enums.creditsfarm;

/**
 * 种植状态：0-初始化 1-种植成功 2-种植失败 3-已收取
 */
public enum CropStatusEnum {
    CROP_STATUS_INIT(0, "初始化"),
    CROP_STATUS_SUC(1, "种植成功"),
    CROP_STATUS_FAIL(2, "种植失败"),
    CROP_STATUS_DONE(3, "已收取"),
    ;


    private Integer code;
    private String desc;

    CropStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CropStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (CropStatusEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
