package cn.com.duiba.activity.center.api.enums.singleAward;

import cn.com.duiba.activity.center.api.tool.DateUtil;
import org.apache.commons.lang.StringUtils;

import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2023/6/8 16:11
 */
public enum SingleAwardDateTypeEnum {
    DAY("day", "日"),
    WEEK("week", "周"),
    MONTH("month", "月"),
    FOREVER("forever", "永久"),
    ;

    private String type;
    private String desc;

    SingleAwardDateTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static SingleAwardDateTypeEnum getByType(String type) {
        if (StringUtils.isBlank(type)) {
            return null;
        }
        SingleAwardDateTypeEnum[] values = SingleAwardDateTypeEnum.values();
        for (SingleAwardDateTypeEnum value : values) {
            if (Objects.equals(value.getType(), type)) {
                return value;
            }
        }
        return null;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static Date getStartDate(String dateType) {
        if (dateType == null || Objects.equals(dateType, SingleAwardDateTypeEnum.FOREVER.getType())) {
            return null;
        }
        // 当日开始时间
        if (Objects.equals(dateType, SingleAwardDateTypeEnum.DAY.getType())) {
            return cn.com.duiba.wolf.utils.DateUtils.getDayStartTime(new Date());
        }
        // 本周第一天
        if (Objects.equals(dateType, SingleAwardDateTypeEnum.WEEK.getType())) {
            return DateUtil.getMondayDate(new Date());
        }
        // 当月第一天
        if (Objects.equals(dateType, SingleAwardDateTypeEnum.MONTH.getType())) {
            Date monthFirstDay = cn.com.duiba.wolf.utils.DateUtils.getMonthDayByIndex(new Date(), 1);
            return cn.com.duiba.wolf.utils.DateUtils.getDayStartTime(monthFirstDay);
        }
        return null;
    }

    public static Date getEndDate(String dateType) {
        if (dateType == null || Objects.equals(dateType, SingleAwardDateTypeEnum.FOREVER.getType())) {
            return null;
        }
        // 当日23:59:59时间
        if (Objects.equals(dateType, SingleAwardDateTypeEnum.DAY.getType())) {
            return cn.com.duiba.wolf.utils.DateUtils.getDayEndTime(new Date());
        }
        // 本周最后一条
        if (Objects.equals(dateType, SingleAwardDateTypeEnum.WEEK.getType())) {
            return DateUtil.getSundayDate(new Date());
        }
        // 当月最后一天
        if (Objects.equals(dateType, SingleAwardDateTypeEnum.MONTH.getType())) {
            return getEndDayOfMonth();
        }
        return null;
    }

    //获取当前月最后一天：
    public static Date getEndDayOfMonth(){
        Calendar cale = Calendar.getInstance();
        cale.add(Calendar.MONTH, 1);
        cale.set(Calendar.DAY_OF_MONTH, 0);
        cale.set(Calendar.HOUR_OF_DAY,23);
        cale.set(Calendar.MINUTE,59);
        cale.set(Calendar.SECOND,59);
        return cale.getTime();
    }
}
