package cn.com.duiba.activity.center.api.remoteservice.singleAward;

import cn.com.duiba.activity.center.api.domain.dto.singleAward.SingleAwardFastRecordDto;

import java.util.Date;
import java.util.List;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;


@AdvancedFeignClient
public interface RemoteSingleAwardFastRecordService {

	Integer save(SingleAwardFastRecordDto singleAwardFastRecordDto);

    void deleteById(Long id) throws BizException;

    void deleteBatchByIds(List<Long> ids) throws BizException;

    Integer updateById(SingleAwardFastRecordDto singleAwardFastRecordDto) throws BizException;

    SingleAwardFastRecordDto getById(Long id) throws BizException;

    List<SingleAwardFastRecordDto> listByIds(List<Long> ids) throws BizException;

    /**
     * 通过订单号查询加速记录
     * @param activityOrderNum
     * @param status
     * @return
     */
    SingleAwardFastRecordDto getByActivityOrderNumAndStatus(Long activityOrderNum, String status);

    /**
     * 删除加速记录
     * @param activityOrderNum
     * @param status
     * @return
     */
    Integer deleteByActivityOrderNumAndStatus(Long activityOrderNum, String status);

    /**
     * 过期加速记录
     * @param status
     * @return
     */
    List<SingleAwardFastRecordDto> findExpiredByStatus(String status);

    /**
     * 订单超时
     * @param fastId
     */
    void payTimeout(Long fastId);

    /**
     * 删除退款加速记录
     * @param fastId
     */
    void deleteRefundFastRecord(Long fastId);
}
