package cn.com.duiba.activity.center.api.remoteservice.freegroup;

import cn.com.duiba.activity.center.api.dto.freegroup.FreeGroupBackendConfigDto;
import cn.com.duiba.activity.center.api.dto.freegroup.FreeGroupItemDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/3/20 19:12
 * @description:
 */
@AdvancedFeignClient
public interface RemoteFreeGroupBackendService {

	/**
	 * 保存活动配置
	 */
	Long save(FreeGroupBackendConfigDto freeGroupBackendConfigDto) throws BizException;

	/**
	 * 获取活动配置详情
	 */
	FreeGroupBackendConfigDto find(Long id);

	/**
	 * 分页查询活动商品配置
	 */
	List<FreeGroupItemDto> findItemPage(Long configId, Integer pageNo, Integer pageSize);
}
