package cn.com.duiba.activity.center.api.remoteservice.iqiyi;

import cn.com.duiba.activity.center.api.dto.iqiyi.HappyCodeDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: lufeng
 * @Description:
 * @Date: Created in 2019/11/18
 */
@AdvancedFeignClient
public interface RemoteHappyCodeService {

    /**
     * 插入
     * @param dto
     * @return
     */
    Long insert(HappyCodeDto dto);

    /**
     * 开奖
     * @param id
     * @param consumerExchangeId
     * @return
     */
    int openPrize(Long id, Long consumerExchangeId, String orderNum);

    /**
     * 通过主键查询记录
     * @param id
     * @return
     */
    HappyCodeDto getById(Long id);

    /**
     * 通过用户id查询所有记录
     * @param consumerId
     * @return
     */
    List<HappyCodeDto> listByConsumerId(Long consumerId);

    /**
     * 通过用户id查询某期记录
     * @param consumerId
     * @param phaseId
     * @return
     */
    List<HappyCodeDto> listByConsumerIdAndPhaseId(Long consumerId, Long phaseId);

    /**
     * 按期次id和商品id查询所有记录数量
     * @param phaseId
     * @return
     */
    Long getCount(Long phaseId, Long itemId);

    /**
     * 通过期次id随机获取一条记录
     * @param phaseId
     * @param start
     * @return
     */
    HappyCodeDto getRandomByPhaseId(Long phaseId, Long itemId, int start);

    /**
     * 通过happyCode查询记录
     * @param happyCode
     * @return
     */
    HappyCodeDto getByHappyCode(String happyCode);
}
